/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.truststore.service;

import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.signals.CertificatesParser;
import com.floragunn.signals.truststore.rest.CertificateRepresentation;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.security.auth.x500.X500Principal;

class CertificateParser {
    CertificateParser() {
    }

    public ImmutableList<CertificateRepresentation> parse(Collection<String> certificates) throws ConfigValidationException {
        ArrayList<CertificateRepresentation> list = new ArrayList<CertificateRepresentation>();
        for (String certificate : certificates) {
            CertificateRepresentation certificateRepresentation = this.parseCertificate(certificate);
            list.add(certificateRepresentation);
        }
        return ImmutableList.of(list);
    }

    private CertificateRepresentation parseCertificate(String singleCertificate) throws ConfigValidationException {
        X509Certificate x509 = CertificatesParser.parseCertificates(singleCertificate).stream().filter(X509Certificate.class::isInstance).map(X509Certificate.class::cast).findFirst().get();
        return new CertificateRepresentation(CertificateParser.readSerialNumberAsString(x509), CertificateParser.dateToLocalDateTime(x509.getNotBefore()), CertificateParser.dateToLocalDateTime(x509.getNotAfter()), CertificateParser.principalToString(x509.getIssuerX500Principal()), CertificateParser.principalToString(x509.getSubjectX500Principal()), singleCertificate);
    }

    private static String principalToString(X500Principal principal) {
        return principal == null ? null : principal.getName();
    }

    private static String readSerialNumberAsString(X509Certificate x509Certificate) {
        BigInteger serialNumber = x509Certificate.getSerialNumber();
        return serialNumber == null ? null : serialNumber.toString(16);
    }

    private static Instant dateToLocalDateTime(Date date) {
        return date == null ? null : Instant.ofEpochMilli(date.getTime());
    }
}

